/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * regx23.h                                                            *
   * Christoph Schmidt BID R&D, 19. Sep. 1997                          *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   ***********************************************************************
*/


#include "regxdir.h"


#define MERGE_EXEGET_0(cmd)	CMD_MERGE (CMDG_EXEGET_0, cmd)


/* MASTER BLOCK ATTRIBUTES */
/* BestMasterBlockLineRead() */
#define CMDM_EXE_MBLK_LINEREAD	0x23
#define CMD_EXE_MBLK_LINEREAD   	MERGE_EXEGET_0 (CMDM_EXE_MBLK_LINEREAD)
#define IN_EXE_MBLK_LINEREAD		 2  /* (page,offset) */
#define OUT_EXE_MBLK_LINEREAD		 1  /* eop */


/* MASTER ATTRIBUTES */
/* BestMasterAttrPhaseRead() */
#define CMDM_EXE_MATTR_PHASEREAD	0x32
#define CMD_EXE_MATTR_PHASEREAD   	MERGE_EXEGET_0 (CMDM_EXE_MATTR_PHASEREAD)
#define IN_EXE_MATTR_PHASEREAD		 0
#define OUT_EXE_MATTR_PHASEREAD		 0

/* BestMasterAttrLineRead() */
#define CMDM_EXE_MATTR_LINEREAD	0x33
#define CMD_EXE_MATTR_LINEREAD   	MERGE_EXEGET_0 (CMDM_EXE_MATTR_LINEREAD)
#define IN_EXE_MATTR_LINEREAD		 2
#define OUT_EXE_MATTR_LINEREAD		 0

/* BestMasterAttrGrpLineRead() */
#define CMDM_EXE_MATTR_GRPLINEREAD	0x34
#define CMD_EXE_MATTR_GRPLINEREAD   	MERGE_EXEGET_0 (CMDM_EXE_MATTR_GRPLINEREAD)
#define IN_EXE_MATTR_GRPLINEREAD		 3
#define OUT_EXE_MATTR_GRPLINEREAD		 0

/* BestMasterAttrPropGet() */
#define CMDM_EXE_MATTR_PROP_GET	0x35
#define CMD_EXE_MATTR_PROP_GET   	MERGE_EXEGET_0 (CMDM_EXE_MATTR_PROP_GET)
#define IN_EXE_MATTR_PROP_GET		 1
#define OUT_EXE_MATTR_PROP_GET		 4

/* TARGET ATTRIBUTES */
/* BestTargetAttrPhaseRead() */
#define CMDM_EXE_TATTR_PHASEREAD	0x52
#define CMD_EXE_TATTR_PHASEREAD   	MERGE_EXEGET_0 (CMDM_EXE_TATTR_PHASEREAD)
#define IN_EXE_TATTR_PHASEREAD		 0
#define OUT_EXE_TATTR_PHASEREAD		 0

/* BestTargetAttrLineRead() */
#define CMDM_EXE_TATTR_LINEREAD	0x53
#define CMD_EXE_TATTR_LINEREAD   	MERGE_EXEGET_0 (CMDM_EXE_TATTR_LINEREAD)
#define IN_EXE_TATTR_LINEREAD		 2
#define OUT_EXE_TATTR_LINEREAD		 0

/* BestTargetAttrGroupLineRead() */
#define CMDM_EXE_TATTR_GRPLINEREAD	0x54
#define CMD_EXE_TATTR_GRPLINEREAD   	MERGE_EXEGET_0 (CMDM_EXE_TATTR_GRPLINEREAD)
#define IN_EXE_TATTR_GRPLINEREAD		 3
#define OUT_EXE_TATTR_GRPLINEREAD		 0

/* BestTargetAttrPropGet() */
#define CMDM_EXE_TATTR_PROP_GET	0x55
#define CMD_EXE_TATTR_PROP_GET   	MERGE_EXEGET_0 (CMDM_EXE_TATTR_PROP_GET)
#define IN_EXE_TATTR_PROP_GET		 1
#define OUT_EXE_TATTR_PROP_GET		 4

/* BestMasterByteEnableRead() */
#define CMDM_EXE_MBYTEENABLE_READ	0x60
#define CMD_EXE_MBYTEENABLE_READ   	MERGE_EXEGET_0 (CMDM_EXE_MBYTEENABLE_READ)
#define IN_EXE_MBYTEENABLE_READ		 1
#define OUT_EXE_MBYTEENABLE_READ     1

/* BestExerciserGenPropGet() */
#define CMDM_EXE_EGEN_PROP_GET	    0x70
#define CMD_EXE_EGEN_PROP_GET   	MERGE_EXEGET_0 (CMDM_EXE_EGEN_PROP_GET)
#define IN_EXE_EGEN_PROP_GET		 1
#define OUT_EXE_EGEN_PROP_GET		 4
